/**
 * SPDX license identifier: MPL-2.0
 *
 * Copyright (C) 2017, ADIT GmbH
 *
 * This file is part of GENIVI Project AudioManager.
 *
 * Contributions are licensed to the GENIVI Alliance under one or more
 * Contribution License Agreements.
 *
 * \copyright
 * This Source Code Form is subject to the terms of the
 * Mozilla Public License, v. 2.0. If a  copy of the MPL was not distributed with
 * this file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *
 * \author Mattia Guerra, mguerra@de.adit-jv.com ADIT 2017
 * \author Jens Lorenz, jlorenz@de.adit-jv.com ADIT 2017
 *
 * \file CAmLogWrapper.cpp
 * For further information see http://www.genivi.org/.
 *
 */

#include "CAmLogWrapper.h"
#include "CAmLoggerDlt.h"
#include "CAmLoggerStdOut.h"
#include "CAmLoggerFile.h"

using namespace std;

namespace am
{

IAmLogger*      CAmLogWrapper::mpLogger         = NULL;
string          CAmLogWrapper::mAppId           = "";
string          CAmLogWrapper::mDescription     = "";
bool            CAmLogWrapper::mDebugEnabled    = true;
am_LogService_e CAmLogWrapper::mLogService      = DEFAULT_LOG_SERVICE;
string          CAmLogWrapper::mFilename        = "";
bool            CAmLogWrapper::mOnlyError       = false;

CAmLogWrapper::CAmLogWrapper(void)
{
}

IAmLogger* CAmLogWrapper::instanctiateOnce(const char *appid, const char * description,
    const bool debugEnabled, const am_LogService_e logService,
    const string Filename, bool onlyError)
{
    mAppId = string(appid);
    mDescription = string(description);
    mDebugEnabled = debugEnabled;
    mLogService = logService;
    mFilename = Filename;
    mOnlyError = onlyError;
    return instance(mLogService);
}

IAmLogger* CAmLogWrapper::instance(const am_LogService_e service)
{
    if (mpLogger)
        return mpLogger;

    switch (service)
    {
#ifdef WITH_DLT
    case LOG_SERVICE_DLT:
        mpLogger = new CAmLoggerDlt();
        break;
#endif
    case LOG_SERVICE_STDOUT:
        mpLogger = new CAmLoggerStdOut(mDebugEnabled, mOnlyError);
        break;
    case LOG_SERVICE_FILE:
        mpLogger = new CAmLoggerFile(mDebugEnabled, mFilename, mOnlyError);
        break;
    default:
        mpLogger = new CAmLoggerStdOut(false, mOnlyError);
        break;
    }
    mpLogger->registerApp(mAppId.c_str(), mDescription.c_str());
    return mpLogger;
}

CAmLogWrapper::~CAmLogWrapper()
{
    if (mpLogger)
    {
        mpLogger->unregisterApp();
        delete mpLogger;
    }
}
}
